/* File: RoombaKarel.java
 * 
 * A Karel program in which Karel picks up all the beepers in a
 * square world.  Karel is assumed to start at (1, 1) and each
 * corner will have no more than one beeper on it.
 */

import stanford.karel.*;

public class RoombaKarel extends SuperKarel {
	public void run() {
		while (leftIsClear()) {
			cleanOneRow();
			moveToNextRow();
		}
		cleanOneRow();
	}
	
	/* Precondition:  Karel is facing East at the start of a row.
	 * Postcondition: Karel is facing East at the start of a row, but the row
	 *                has all the beepers cleared from it
	 */
	private void cleanOneRow() {
		sweepRow();
		moveBackToStart();
	}
	
	/* Precondition:  Karel is facing East at the start of a row.
	 * Postcondition: Karel is facing East at the end of the row,
	 *                but all the beepers are cleared.
	 */
	private void sweepRow() {
		if (beepersPresent()) {
			pickBeeper();
		}
		while (frontIsClear()) {
			move();
			if (beepersPresent()) {
				pickBeeper();
			}
		}
	}
	
	/* Precondition:  Karel is facing East at the end of the row.
	 * Postcondition: Karel is facing East at the start of the row.
	 */
	private void moveBackToStart() {
		turnAround();
		while (frontIsClear()) {
			move();
		}
		turnAround();
	}
	
	/* Precondition:  Karel is facing East at the start of the row.
	 * Postcondition: Karel is facing East at the start of the next row.
	 */
	private void moveToNextRow() {
		turnLeft();
		move();
		turnRight();
	}
}
